import excel "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/VolBetaLongTerm3.xlsx", sheet("260DayVol") firstrow clear

local myvars "jpm_vol gs_vol wf_vol baml_vol citi_vol ms_vol" 

foreach X of varlist `myvars'{
gen str13 `X'name=" `X'"
}

stack date jpm_vol jpm_volname date baml_vol baml_volname date gs_vol gs_volname date wf_vol wf_volname date citi_vol citi_volname date ms_vol ms_volname, into (date_vol vol vol_name)
gen year = year(date_vol)
split vol_name,p("_")
rename vol_name1 name
drop vol_name2 vol_name
rename date_vol date

format date %td 

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/vol_lt.dta", replace 

*** now do beta 
import excel "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/VolBetaLongTerm3.xlsx", sheet("BETA") firstrow clear

local myvars "jpm_beta gs_beta wf_beta baml_beta citi_beta ms_beta" 

foreach X of varlist `myvars'{
gen str13 `X'name=" `X'"
}

stack date jpm_beta jpm_betaname date baml_beta baml_betaname date gs_beta gs_betaname date wf_beta wf_betaname date citi_beta citi_betaname date ms_beta ms_betaname, into (date_beta beta beta_name)
gen year = year(date_beta)
split beta_name,p("_")
rename beta_name1 name
drop beta_name2 beta_name
rename date_beta date

format date %td 

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/beta_lt.dta", replace 


*** now do 30 vol 
import excel "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/VolBetaLongTerm3.xlsx", sheet("30DayVol") firstrow clear

local myvars "jpm_vol30 gs_vol30 wf_vol30 baml_vol30 citi_vol30 ms_vol30" 

foreach X of varlist `myvars'{
gen str13 `X'name=" `X'"
}

stack date jpm_vol30 jpm_vol30name date baml_vol30 baml_vol30name date gs_vol30 gs_vol30name date wf_vol30 wf_vol30name date citi_vol30 citi_vol30name date ms_vol30 ms_vol30name, into (date_vol30 vol30 vol30_name)
gen year = year(date_vol30)
split vol30_name,p("_")
rename vol30_name1 name
drop vol30_name2 vol30_name
rename date_vol30 date

format date %td 

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/vol30_lt.dta", replace 

*** now merge 
merge m:m date name using "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/beta_lt.dta"
drop _merge

merge m:m date name using "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/vol_lt.dta"
drop _merge 

drop _stack 

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/merge_lt.dta", replace 

*** now make charts 
*** do one per bank 

cd "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/Tables"

use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/merge_lt.dta", clear 

drop if year >2015 

graph twoway line beta date if (name == "baml" & year>1980), xtitle("") title("Beta for Bank of America Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export baml_beta.png, replace 

graph twoway line beta date if (name == "citi" & year>1987), xtitle("") title("Beta for Citigroup Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export citi_beta.png, replace 

graph twoway line beta date if (name == "ms" & year>1994), xtitle("") title("Beta for Morgan Stanley Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export ms_beta.png, replace 

graph twoway line beta date if (name == "gs" & year>1999), xtitle("") title("Beta for Goldman Sachs Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export gs_beta.png, replace 

graph twoway line beta date if (name == "wf" & year>1980), xtitle("") title("Beta for Wells Fargo Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export wf_beta.png, replace 

graph twoway line beta date if (name == "jpm" & year>1980), xtitle("") title("Beta for JP Morgan Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export jpm_beta.png, replace 


use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/merge_lt.dta", clear 

graph twoway line vol date if (name == "baml" & year>1980), xtitle("") title("Volatility for Bank of America Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export baml_vol.png, replace 

graph twoway line vol date if (name == "citi" & year>1987), xtitle("") title("Volatility for Citigroup Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export citi_vol.png, replace 

graph twoway line vol date if (name == "ms" & year>1994), xtitle("") title("Volatility for Morgan Stanley Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export ms_vol.png, replace 

graph twoway line vol date if (name == "gs" & year>1999), xtitle("") title("Volatility for Goldman Sachs Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export gs_vol.png, replace 

graph twoway line vol date if (name == "wf" & year>1980), xtitle("") title("Volatility for Wells Fargo Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export wf_vol.png, replace 

graph twoway line vol date if (name == "jpm" & year>1980), xtitle("") title("Volatility for JP Morgan Over Time") xlabel(,labsize(small)) cmissing(n) 

graph export jpm_vol.png, replace

**** now we need to add in price data to do the correlations that LHS wants 
import delimited "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/prices_lt_v2.csv", encoding(ISO-8859-1)clear

**keep if ticker == "BAC" | ticker == "C" | ticker == "GS" | ticker == "JPM" | ticker == "MS"| ticker == "JPM" 
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/prices_lt.dta", replace 

gen date2 = date(date, "MDY")
format date2 %td
drop date 
rename date2 date 

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/prices_lt.dta", replace 

*** now index 
import delimited "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/index_lt_v2.csv", encoding(ISO-8859-1)clear
tostring date, gen(date_string)
gen date2 = date(date_string, "YMD")
format date2 %td
drop date date_string
rename date2 date 

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/index_lt.dta", replace 
merge 1:m date using "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/prices_lt.dta"
drop _merge 
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/index_prices_lt.dta", replace 

**** we also need to add in vix 
import delimited "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/vix_lt.csv", encoding(ISO-8859-1)clear
gen date2 = date(date, "MDY")
format date2 %td
drop date 
rename date2 date 
merge 1:m date using "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/index_prices_lt.dta"
drop _merge 
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/index_prices_lt.dta", replace 


*** we will eventually have to merge with this file 
use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/merge_lt.dta", clear 
merge m:m date using "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/index_prices_lt.dta"

**** we need moving averages of (1) vol (2) price (3) relative vol (4) relative price 


*** we also want to plot relative vol vs relative price
*gen vol_div_market = vol/spx_index_vol
gen vol_div_market = vol/spx_index_vol

gen price_div_market = prc/spindx

capture gen year = year(date) 
gen month = month(date)

by  year month, sort: egen mean_vol_div_market=mean(vol_div_market)
by  year month, sort: egen mean_price_div_market=mean(price_div_market)

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/merge_lt_v2.dta", replace 

egen id = group(name)
tsset id date 

**** we need moving averages of (1) vol (2) price (3) relative vol (4) relative price 

tssmooth ma vol_ma = vol, window(90)
tssmooth ma price_ma = prc, window(90)
tssmooth ma vol_div_market_ma = vol_div_market, window(90)
tssmooth ma price_div_market_ma = price_div_market, window(90)


cd "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/Tables"

drop if year>2015 

label var vol_div_market_ma "Volatility"
label var price_div_market_ma "Price"

graph twoway (line vol_div_market_ma date, yaxis(1) cmissing(no) ytitle("Volatility/Market")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "baml" & year>1980), xtitle("") title("Bank of America") xlabel(,labsize(small)) 

su vol_div_market if (year>= 2010 & name == "baml") 

graph export baml_vol_price_market.png, replace 

graph twoway (line vol_div_market_ma date, yaxis(1) cmissing(no) ytitle("Volatility/Market")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "citi" & year>1987), xtitle("") title("Citigroup") xlabel(,labsize(small)) 

graph export citi_vol_price_market.png, replace 

graph twoway (line vol_div_market_ma date, yaxis(1) cmissing(no) ytitle("Volatility/Market")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "ms" & year>1994), xtitle("") title("Morgan Stanley") xlabel(,labsize(small)) 

graph export ms_vol_price_market.png, replace 

graph twoway (line vol_div_market_ma date, yaxis(1) cmissing(no) ytitle("Volatility/Market")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "gs" & year>1999), xtitle("") title("Goldman Sachs") xlabel(,labsize(small))  

graph export gs_vol_price_market.png, replace 

graph twoway (line vol_div_market_ma date, yaxis(1) cmissing(no) ytitle("Volatility/Market")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2)))  if (name == "wf" & year>1980), xtitle("") title("Wells Fargo") xlabel(,labsize(small))  

graph export wf_vol_price_market.png, replace 

graph twoway (line vol_div_market_ma date, yaxis(1) cmissing(no) ytitle("Volatility/Market")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "jpm" & year>1980), xtitle("") title("JP Morgan") xlabel(,labsize(small)) 

graph export jpm_vol_price_market.png, replace

**** now we want three month moving average of relative vol and relative price (both compared to S&P 500)

label var vol_ma "Volatility"
label var price_ma "Price"

graph twoway (line vol_ma date, yaxis(1) cmissing(no) ytitle("Volatility")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2))) if (name == "baml" & year>1980), xtitle("") title("Bank of America") xlabel(,labsize(small)) 

graph export baml_vol_price.png, replace 

graph twoway (line vol_ma date, yaxis(1) cmissing(no) ytitle("Volatility")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2))) if (name == "citi" & year>1987), xtitle("") title("Citigroup") xlabel(,labsize(small)) 

graph export citi_vol_price.png, replace 

graph twoway (line vol_ma date, yaxis(1) cmissing(no) ytitle("Volatility")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2))) if (name == "ms" & year>1994), xtitle("") title("Morgan Stanley") xlabel(,labsize(small)) 

graph export ms_vol_price.png, replace 

graph twoway (line vol_ma date, yaxis(1) cmissing(no) ytitle("Volatility")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2))) if (name == "gs" & year>1999), xtitle("") title("Goldman Sachs") xlabel(,labsize(small))  

graph export gs_vol_price.png, replace 

graph twoway (line vol_ma date, yaxis(1) cmissing(no) ytitle("Volatility")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2)))  if (name == "wf" & year>1980), xtitle("") title("Wells Fargo") xlabel(,labsize(small))  

graph export wf_vol_price.png, replace 

graph twoway (line vol_ma date, yaxis(1) cmissing(no) ytitle("Volatility")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2))) if (name == "jpm" & year>1980), xtitle("") title("JP Morgan") xlabel(,labsize(small)) 

graph export jpm_vol_price.png, replace

**** we also want to look at interest rate moves, so we need to merge with our interest rate spreadsheet 
use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/merge_lt_v2.dta", clear 

capture drop _merge 

save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/merge_lt_v2.dta", replace 

import delimited "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/interest_rates.csv", varnames(1) encoding(ISO-8859-1)clear

gen risk_free = real(_month)
drop _month 

gen date2 = date(date, "MDY")
format date2 %td
drop date 
rename date2 date 

merge 1:m date using "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/merge_lt_v2.dta"
br if _merge != 3 & year > 1990 
keep if _merge == 3  
 
drop _merge
save "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/merge_lt_interest_rates.dta", replace 

**** still need to do these graphs 
gen price_div_market = prc/spindx

egen id = group(name)
tsset id date 

**** we need moving averages of (1) vol (2) price (3) relative vol (4) relative price 

tssmooth ma risk_free_ma = risk_free, window(90)
tssmooth ma price_ma = prc, window(90)
tssmooth ma price_div_market_ma = price_div_market, window(90) 

drop if year > 2015 

drop if year < 1990 

cd "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/Tables"

label var risk_free_ma "Risk-Free"
label var price_ma "Price"
label var price_div_market_ma "Price/Market" 

graph twoway (line risk_free_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2))) if (name == "baml" & year>1980), xtitle("") title("Bank of America") xlabel(,labsize(small)) 

graph export baml_rf_price.png, replace 

graph twoway (line risk_free_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2))) if (name == "citi" & year>1987), xtitle("") title("Citigroup") xlabel(,labsize(small)) 

graph export citi_rf_price.png, replace 

graph twoway (line risk_free_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2))) if (name == "ms" & year>1994), xtitle("") title("Morgan Stanley") xlabel(,labsize(small)) 

graph export ms_rf_price.png, replace 

graph twoway (line risk_free_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2))) if (name == "gs" & year>1999), xtitle("") title("Goldman Sachs") xlabel(,labsize(small))  

graph export gs_rf_price.png, replace 

graph twoway (line risk_free_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2)))  if (name == "wf" & year>1980), xtitle("") title("Wells Fargo") xlabel(,labsize(small))  

graph export wf_rf_price.png, replace 

graph twoway (line risk_free_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2))) if (name == "jpm" & year>1980), xtitle("") title("JP Morgan") xlabel(,labsize(small)) 

graph export jpm_rf_price.png, replace   

*** same set of tables, but instead we want to do relative to market price

graph twoway (line risk_free_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "baml" & year>1980), xtitle("") title("Bank of America") xlabel(,labsize(small)) 

graph export baml_rf_price_div_market.png, replace 

graph twoway (line risk_free_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "citi" & year>1987), xtitle("") title("Citigroup") xlabel(,labsize(small)) 

graph export citi_rf_price_div_market.png, replace 

graph twoway (line risk_free_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "ms" & year>1994), xtitle("") title("Morgan Stanley") xlabel(,labsize(small)) 

graph export ms_rf_price_div_market.png, replace 

graph twoway (line risk_free_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "gs" & year>1999), xtitle("") title("Goldman Sachs") xlabel(,labsize(small))  

graph export gs_rf_price_div_market.png, replace 

graph twoway (line risk_free_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2)))  if (name == "wf" & year>1980), xtitle("") title("Wells Fargo") xlabel(,labsize(small))  

graph export wf_rf_price_div_market.png, replace 

graph twoway (line risk_free_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "jpm" & year>1980), xtitle("") title("JP Morgan") xlabel(,labsize(small)) 

graph export jpm_rf_price_div_market.png, replace   

*** we want to use T-bill 3% to look at interest rate moves 
/*use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/bw_mve.dta", clear

drop id 
drop name
rename short_name name 
egen id = group(name)
drop output_indicator 
by id date, sort: gen output_indicator = _n 
drop if output_indicator != 1
tsset id date 

format date %td 

*** three month moving avg of interest rate and price and plot on the same graph 

cd "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Data September 2016/Tables"

tssmooth ma rf_ma = t_bill_3_percent, window(90)
tssmooth ma price_ma = price, window(90)

label var rf_ma "Risk-Free Rate"
label var price_ma "Price"

graph twoway (line rf_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free Rate")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2))) if (name == "baml" & year>1998), xtitle("") title("Bank of America") xlabel(,labsize(small)) 

graph export baml_rf.png, replace 

graph twoway (line rf_ma date, yaxis(1) cmissing(no) ytitle("Risk-Free Rate")) || (line price_ma date, yaxis(2) cmissing(no) ytitle("Price", axis(2))) if (name == "citi" & year>1998), xtitle("") title("Citigroup") xlabel(,labsize(small)) 

graph export citi_rf.png, replace*/

